/**
* Script: queststate.js
* Written by: Radnen
* Updated: 12/18/2010
**/

function QuestState(name)
{
	if (!name) name = "QuestState";
	this.inherit = State;
	this.inherit(name);
	
	var quests = Genesis.player.quests;
	var quest = null;
	this.x = SW/2-250;
	this.y = SH/2-166;
	
	var c_holder = new ControlHolder(0, 0, SW, SH);
	var panel = new Panel(c_holder, this.x, this.y, SW, SH);
	
	var questitems = new ListBox(panel, 20, 36, 260, 220);
	for (var i = 0; i < quests.length; ++i) {
		questitems.addText(quests[i].name, function() {
			quest = Utility.findIn(quests, questitems.item.text, "name");
		});
	}
	
	var okayitem = new EasyButton("Okay", this.x+235, this.y+280);
	okayitem.onClick.add(function(sender) {
		Audio.playSound(System.clickSnd);
		sender.hide();
	}, this);
	
	this.render.add(function() {
		Resources.images.questmenu.blit(this.x, this.y);
		if (quest != null) {
			Rectangle(this.x+290, this.y+12, 200, 230, Colors.clearBlack);
			DrawQuestDesc(quest, this.x + 290, this.y+12, 200, 230);
		}
		c_holder.draw();
		Rectangle(this.x+24, this.y+16, 260, 20, Colors.clearBlack);
		System.textFont.drawText(this.x+24, this.y+16, "Player's Quests:");
		if (quests.length == 0)
			System.textFont.drawText(this.x+24, this.y+36, "[Doing Nothing]");
		okayitem.draw();
	});
	
	this.update.add(function() {
		c_holder.update();
		okayitem.update();
	});
	
	c_holder.controls.push(panel);
	c_holder.focusedControl = panel;
	panel.controls.push(questitems);
}